// Copyright Epic Games, Inc. All Rights Reserved.

#include "CsdkEditor.h"

#include "ToolMenus.h"
#include "Slate/CsdkAboutScreen.h"

#define LOCTEXT_NAMESPACE "FCsdkEditorModule"

void FCsdkEditorModule::StartupModule()
{
	RegisterCsdkMenu();
}

void FCsdkEditorModule::ShutdownModule()
{

}


void FCsdkEditorModule::RegisterCsdkMenu() const
{
	const FName LevelEditorMenuName("LevelEditor.MainMenu");
	UToolMenu* MainMenu = UToolMenus::Get()->ExtendMenu(LevelEditorMenuName);
	FToolMenuSection& MainSection = MainMenu->FindOrAddSection(NAME_None);
	const FToolMenuEntry CsdkMenuEntry = FToolMenuEntry::InitMenuEntry(
		"CSDK",
		LOCTEXT("CSDK", "Hero CSDK"),
		LOCTEXT("CSDK_ToolTip", "Hero Chat SDK"),
		FSlateIcon{},
		FToolUIActionChoice{}
	);
	MainSection.AddEntry(CsdkMenuEntry);
	RegisterPullDown();
}

void FCsdkEditorModule::RegisterPullDown() const
{
	UToolMenu* CsdkMenu = UToolMenus::Get()->ExtendMenu(TEXT("LevelEditor.MainMenu.CSDK"));
	FToolMenuSection& MainSection = CsdkMenu->FindOrAddSection(NAME_None);
	MainSection.AddEntry(GetAboutWindowEntry());
}

FToolMenuEntry FCsdkEditorModule::GetAboutWindowEntry() const
{
		const FUIAction MenuUIAction = FUIAction{
			FExecuteAction::CreateRaw(this,&FCsdkEditorModule::ExcuteAboutWindow),
			FCanExecuteAction::CreateLambda([](){ return true; })
			};
		
		return FToolMenuEntry::InitMenuEntry(
			TEXT("About"),
			LOCTEXT("CSDKAbout", "AboutSDK"),
			LOCTEXT("CSDKAbout", "About CSDK ToopTip"),
			FSlateIcon{},
			MenuUIAction
			);
}

void FCsdkEditorModule::ExcuteAboutWindow() const
{
	TSharedPtr<SWindow> AboutWindow = SNew(SWindow)
		.Title(LOCTEXT("CSDKWindowTitle","About CSDK"))
		.ClientSize(FVector2D(600.f, 200.f))
		.SizingRule(ESizingRule::FixedSize)
		.AutoCenter(EAutoCenter::PreferredWorkArea)
		.SupportsMaximize(false)
		.SupportsMinimize(false)
		[
			SNew(SCsdkAboutScreen)
		];
	FSlateApplication::Get().AddModalWindow(AboutWindow.ToSharedRef(),nullptr);
}

#undef LOCTEXT_NAMESPACE
	
IMPLEMENT_MODULE(FCsdkEditorModule, CsdkEditor)