// Fill out your copyright notice in the Description page of Project Settings.


#include "Slate/CsdkAboutScreen.h"
#include "CsdkRuntime.h"
#include "SlateOptMacros.h"
#include "Widgets/Images/SImage.h"

#define LOCTEXT_NAMESPACE "FCsdkEditorModule"

BEGIN_SLATE_FUNCTION_BUILD_OPTIMIZATION
void SCsdkAboutScreen::Construct(const FArguments& InArgs)
{
	const auto& CsdkRuntimeModule = FModuleManager::Get().LoadModuleChecked<FCsdkRuntimeModule>(TEXT("CsdkRuntime"));
	const FText Version = FText::Format( LOCTEXT("VersionLabel", "Version: {0}"), FText::FromString(CsdkRuntimeModule.GetVersion() ) );

	ChildSlot
	[
		SNew(SOverlay)
		+SOverlay::Slot()
		[
			SNew(STextBlock)
			.ColorAndOpacity(FLinearColor(0.7f, 0.7f, 0.7f))
			.Text( Version )
			.Font( FCoreStyle::GetDefaultFontStyle("Regular", 24) )
		]
	];

}
END_SLATE_FUNCTION_BUILD_OPTIMIZATION

#undef LOCTEXT_NAMESPACE