// Fill out your copyright notice in the Description page of Project Settings.

using System;
using System.IO;
using System.Reflection;
using System.Text;
using UnrealBuildTool;

public class CsdkProtobuf : ModuleRules
{
	private string ModulePath
	{
		get { return ModuleDirectory; }
	}

	public CsdkProtobuf(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;

		PublicIncludePaths.AddRange(
			new string[]
			{
				// ... add public include paths required here ...
				Path.Combine(ModulePath)
			}
		);


		PrivateIncludePaths.AddRange(
			new string[]
			{
				// ... add other private include paths required here ...
			}
		);
		PublicDefinitions.Add("HEROAPI_UE4");
		PublicDefinitions.Add("GOOGLE_PROTOBUF_INTERNAL_DONATE_STEAL_INLINE");
		DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
		);

		PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

		PublicDependencyModuleNames.AddRange(new string[] { "Core" });

		// Uncomment if you are using Slate UI
		// PrivateDependencyModuleNames.AddRange(new string[] { "Slate", "SlateCore" });

		// Uncomment if you are using online features
		// PrivateDependencyModuleNames.Add("OnlineSubsystem");

		// To include OnlineSubsystemSteam, add it to the plugins section in your uproject file with the Enabled attribute set to true
		
		ShadowVariableWarningLevel = WarningLevel.Off;
		bEnableUndefinedIdentifierWarnings = false;
		bEnableExceptions = true;
		PublicDefinitions.Add("_CRT_SECURE_NO_WARNINGS");
		if (Target.Platform.Equals(UnrealTargetPlatform.Win64))
		{
			Exception ex = AppendChangeAdditionalCompilerArguments
			(
				Target,
				"/wd4996",
				"/wd4005",
				"/wd4457",
				"/wd4305",
				"/wd4506",
				"/wd4702"
			);
			if (ex != null)
			{
				throw ex;
			}
		} else if (Target.Platform.Equals(UnrealTargetPlatform.IOS)) {
			Exception ex = AppendChangeAdditionalCompilerArguments
			(
				Target,
				"-Wno-undef"
			);
			if (ex != null)
			{
				throw ex;
			}
		} else if (Target.Platform.Equals(UnrealTargetPlatform.Android) || Target.Platform.Equals(UnrealTargetPlatform.Linux)) {
			Exception ex = AppendChangeAdditionalCompilerArguments
			(
				Target,
				"-Wno-undef"
			);
			if (ex != null)
			{
				throw ex;
			}
		}
	}
	private Exception AppendChangeAdditionalCompilerArguments(ReadOnlyTargetRules target, params string[] args)
	{
		//参数为0，则返回报错
		if (args == null || args.Length == 0)
		{
			return new Exception("args is null or size is 0");
		}

		//构建拼接字符串
		StringBuilder arguments = new StringBuilder();
		arguments.Append(" ");
		for (var i = 0; i < args.Length; i++)
		{
			arguments.Append(args[i]);
			if (i < args.Length - 1)
			{
				arguments.Append(" ");
			}
		}

		try
		{
			//获取类型
			Type type = target.GetType();
			//获取实例的非public成员
			FieldInfo field = type.GetField("Inner",
				BindingFlags.Instance | BindingFlags.NonPublic
			);
			if (field == null)
			{
				return new Exception("not found {Inner} in target");
			}

			TargetRules innerRules = (TargetRules)field.GetValue(target);

			innerRules.AdditionalCompilerArguments += arguments.ToString();
			return null;
		}
		catch (Exception e)
		{
			return e;
		}
	}
}