// Copyright Epic Games, Inc. All Rights Reserved.

using System;
using System.IO;
using System.Reflection;
using System.Text;
using UnrealBuildTool;

public class CsdkRuntime : ModuleRules
{
	public CsdkRuntime(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;
		
		PrivateDefinitions.Add("CSDK_MajorVersion=2");
		PrivateDefinitions.Add("CSDK_MiddleVersion=17");
		PrivateDefinitions.Add("CSDK_MinorVersion=0");
		PrivateDefinitions.Add("CSDK_WITH_CHECK");
		
		PublicIncludePaths.AddRange(
			new string[] {
				// ... add public include paths required here ...
			}
			);
				
		
		PrivateIncludePaths.AddRange(
			new string[] {
				Path.Combine(ModuleDirectory,"Private","ProtobufEntry","heroim"),
				Path.Combine(ModuleDirectory,"Private","ProtobufEntry","heroim","client","v3beta","dto"),
				Path.Combine(ModuleDirectory,"Private","ProtobufEntry","logtracer", "client", "v1"),
				// ... add other private include paths required here ...
			}
			);
			
		
		PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"Core", "HTTP", "Engine", "JsonUtilities","Json", 
				// ... add other public dependencies that you statically link with here ...
			}
			);
			
		
		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"CoreUObject",
				"Engine",
				"Slate",
				"SlateCore",
				"WebSockets", 
				"CsdkProtobuf",
				"DeveloperSettings"
				// ... add private dependencies that you statically link with here ...	
			}
			);
		
		
		DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
			);

		if (Target.Version.MajorVersion > 4 && Target.Version.MinorVersion >=3)
		{
			PublicDefinitions.AddRange(new string[] {
				"CSDK_Ticker=FTSTicker",
				"CSDK_TickerHandle=FTSTicker::FDelegateHandle"
			});
			
		}
		else
		{
			PublicDefinitions.AddRange(new string[] {
				"CSDK_Ticker=FTicker",
				"CSDK_TickerHandle=FDelegateHandle"

			});
		}
		PublicDefinitions.Add("HEROAPI_UE4");
		if (Target.Platform.Equals(UnrealTargetPlatform.Win64))
		{
			Exception ex = AppendChangeAdditionalCompilerArguments
			(
				Target, 
				"/wd4800",
				"/wd4946"
			);
			if (ex != null)
			{
				throw ex;
			}
		} 
		else if (Target.Platform == UnrealTargetPlatform.Android)
		{
			PublicDependencyModuleNames.AddRange(new string[] { "Launch" });
			PrivateDependencyModuleNames.Add("AndroidPermission");
		
		}
	}
	
	
	private Exception AppendChangeAdditionalCompilerArguments(ReadOnlyTargetRules target, params string[] args)
	{
		//参数为0，则返回报错
		if (args == null || args.Length == 0)
		{
			return new Exception("args is null or size is 0");
		}

		//构建拼接字符串
		StringBuilder arguments = new StringBuilder();
		arguments.Append(" ");
		for (var i = 0; i < args.Length; i++)
		{
			arguments.Append(args[i]);
			if (i < args.Length - 1)
			{
				arguments.Append(" ");
			}
		}

		try
		{
			//获取类型
			Type type = target.GetType();
			//获取实例的非public成员
			FieldInfo field = type.GetField("Inner",
				BindingFlags.Instance | BindingFlags.NonPublic
			);
			if (field == null)
			{
				return new Exception("not found {Inner} in target");
			}

			TargetRules innerRules = (TargetRules)field.GetValue(target);

			innerRules.AdditionalCompilerArguments += arguments.ToString();
			return null;
		}
		catch (Exception e)
		{
			return e;
		}
	}
}
