#include "ChatRoom/CsdkChatRoomLibrary.h"
#include "Tools/CsdkCommonTools.h"

FCsdkChatRoomId UCsdkChatRoomLibrary::Conv_FStringToChatRoomId(const FString& CustomId)
{
#if UE_SERVER	
	return {};
#endif
	
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	FCsdkChatRoomId Id = {CustomId,FCsdkCommonTools::GetSeverId()};
	return Id;
}

bool UCsdkChatRoomLibrary::IsValid(const FCsdkChatRoomId& A)
{
#if UE_SERVER	
	return {};
#endif
	return A.IsValid();
}


FString UCsdkChatRoomLibrary::Conv_ChatRoomIdToString( const FCsdkChatRoomId& RoomId)
{
#if UE_SERVER	
	return {};
#endif
	return RoomId.ToString();
	
}

bool UCsdkChatRoomLibrary::GetChatRoomInfoById(const FCsdkChatRoomId& RoomId, FCsdkChatRoomInfo& ChatRoomInfo)
{
#if UE_SERVER	
	return {};
#endif
	return FCsdkCommonTools::GetChatRoomManager().GetChatRoomInfoById(RoomId,ChatRoomInfo);
}

TArray<FCsdkChatRoomInfo> UCsdkChatRoomLibrary::GetChatRoomsInfo()
{
#if UE_SERVER	
	return {};
#endif
	return FCsdkCommonTools::GetChatRoomManager().GetChatRoomsInfo();
}
