#include "ChatRoom/CsdkJoinChatRoomAutoCreate.h"
#include "Tools/CsdkCommonTools.h"


UCsdkJoinChatRoomAutoCreate* UCsdkJoinChatRoomAutoCreate::JoinChatRoomAutoCreate(UObject* WorldContextObject,
	const FCsdkChatRoomId& RoomId,const FCsdkChatRoomCreateParam& Param)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkJoinChatRoomAutoCreate* Action = NewObject<UCsdkJoinChatRoomAutoCreate>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->ChatRoomId = RoomId;
	Action->CreateRoomParam = Param;
	return Action;
}

void UCsdkJoinChatRoomAutoCreate::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetChatRoomManager().JoinAutoCreateChatRoom(ChatRoomId,CreateRoomParam,
	[this](const int32 ErrorCode,const FString& ErrorMsg,const FCsdkChatRoomInfo& ChatRoomInfo)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg,ChatRoomInfo);
		this->SetReadyToDestroy();
	});
}
