#include "ChatRoom/CsdkQuitChatRoom.h"
#include "Tools/CsdkCommonTools.h"


UCsdkQuitChatRoom* UCsdkQuitChatRoom::QuitChatRoom(UObject* WorldContextObject, const FCsdkChatRoomId& RoomId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkQuitChatRoom* Action = NewObject<UCsdkQuitChatRoom>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->ChatRoomId = RoomId;
	return Action;
}

void UCsdkQuitChatRoom::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetChatRoomManager().QuitChatRoom(ChatRoomId,
		[this](const int32 ErrorCode,const FString& ErrorMsg)
		{
			if(!this->IsValidLowLevel())
				return;
			
			this->Completed.Broadcast(ErrorCode,ErrorMsg);
			this->SetReadyToDestroy();
		});
}
