#include "ChatRoom/CsdkDissolveChatRoom.h"
#include "Tools/CsdkCommonTools.h"


UCsdkDissolveChatRoom* UCsdkDissolveChatRoom::DissolveChatRoom(UObject* WorldContextObject, const FCsdkChatRoomId& RoomId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkDissolveChatRoom* Action = NewObject<UCsdkDissolveChatRoom>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->ChatRoomId = RoomId;
	return Action;
}

void UCsdkDissolveChatRoom::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetChatRoomManager().DissolveChatRoom(ChatRoomId,
		[this](const int32 ErrorCode,const FString& ErrorMsg)
		{
			if(!this->IsValidLowLevel())
				return;
			
			this->Completed.Broadcast(ErrorCode,ErrorMsg);
			this->SetReadyToDestroy();
		});
}
