#include "ChatRoomTool.h"

heroim::client::v3beta::dto::group::model::GroupKey* CsdkChatRoomTool::MakeGroupKey(const FCsdkChatRoomId& Id)
{
	heroim::client::v3beta::dto::group::model::GroupKey* PbGroupKey = new heroim::client::v3beta::dto::group::model::GroupKey;
	PbGroupKey->set_customid(FSTRING_TO_STD_STRING(Id.CustomId));
	PbGroupKey->set_serverid(FSTRING_TO_STD_STRING(Id.ServerId));
	return PbGroupKey;
}

FCsdkChatRoomInfo CsdkChatRoomTool::ConvertRoomInfo(const heroim::client::v3beta::dto::group::model::Group& PbRoomInfo)
{
	FCsdkChatRoomInfo RoomInfo;
	RoomInfo.RoomId.CustomId =STD_STRING_TO_FSTRING(PbRoomInfo.groupkey().customid()) ;
	RoomInfo.RoomId.ServerId =STD_STRING_TO_FSTRING(PbRoomInfo.groupkey().serverid());
	RoomInfo.RoomType = STD_STRING_TO_FSTRING(PbRoomInfo.grouptype());
	RoomInfo.RoomName = STD_STRING_TO_FSTRING(PbRoomInfo.title());
	RoomInfo.Icon = STD_STRING_TO_FSTRING(PbRoomInfo.iconurl());
	for(const auto& ExtraItem:PbRoomInfo.extra())
	{
		RoomInfo.Extra.Add(STD_STRING_TO_FSTRING(ExtraItem.first),STD_STRING_TO_FSTRING(ExtraItem.second));
	}
	return RoomInfo;
}

FCsdkChatRoomInfo CsdkChatRoomTool::ConvertRoomInfo(const TSharedPtr<FJsonObject>& ChatRoomObject)
{
	FCsdkChatRoomInfo RoomInfo;
	ChatRoomObject->TryGetStringField(TEXT("customId"), RoomInfo.RoomId.CustomId);
	ChatRoomObject->TryGetStringField(TEXT("serverId"), RoomInfo.RoomId.ServerId);
	ChatRoomObject->TryGetStringField(TEXT("type"), RoomInfo.RoomType);
	ChatRoomObject->TryGetStringField(TEXT("title"), RoomInfo.RoomName);
	ChatRoomObject->TryGetStringField(TEXT("iconUrl"), RoomInfo.Icon);
	const TSharedPtr<FJsonObject>* TempExtra;
	if (ChatRoomObject->TryGetObjectField(TEXT("extra"), TempExtra) && TempExtra)
	{
		for (auto It = (*TempExtra)->Values.CreateConstIterator(); It; ++It)
		{
			RoomInfo.Extra.Add(It.Key(), *It.Value()->AsString());
		}
	}
	return RoomInfo;
}
