﻿#include "Consensus/CsdkAccuseToHeroSentiment.h"
#include "Tools/CsdkCommonTools.h"

UCsdkAccuseToHeroSentiment* UCsdkAccuseToHeroSentiment::Accuse(UObject* WorldContextObject, const FCsdkAccuseToSentimentParam& AccuseParam)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkAccuseToHeroSentiment* Action = NewObject<UCsdkAccuseToHeroSentiment>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->AccuseToHeroParam = AccuseParam;
	return Action;
}

void UCsdkAccuseToHeroSentiment::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetConsensusManager().Accuse(AccuseToHeroParam,
	[this](const int32 ErrorCode,const FString& ErrorMsg)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode, ErrorMsg);
		this->SetReadyToDestroy();
	});
}