﻿#include "ConsensusManager.h"

#include "message/message_dto.pb.h"
#include "sentiment/sentiment_dto.pb.h"
#include "Tools/CsdkCommonHttp.h"
#include "Tools/CsdkCommonTools.h"

using namespace heroim::client::v3beta::dto::sentiment;

void FConsensusManager::SensitiveTextCheck(const FString& Content, const FCsdkSensitiveTextCheckParam& ReportParam, const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg, const bool bPassed, const TArray<FString>&)>& CallBack) const
{
	CheckTextRequest Request;
	Request.set_allocated_base(FCsdkCommonTools::MakePbBase());
	Request.set_text(FSTRING_TO_STD_STRING(Content));
	Request.mutable_reporttoherooptions()->set_enabled(ReportParam.Enabled);
	Request.mutable_reporttoherooptions()->set_type(ReportParam.Type);
	Request.mutable_reporttoherooptions()->set_channel_id(ReportParam.ChannelId);
	for (const auto& ExtraItem : ReportParam.ExtendItems)
	{
		Request.mutable_reporttoherooptions()->mutable_extend_items()->insert({FSTRING_TO_STD_STRING(ExtraItem.Key),FSTRING_TO_STD_STRING(ExtraItem.Value)});
	}
		
	
	auto HttpCallBack = [this,CallBack](const int32 ErrorCode, const FString& ErrorMsg,
	                                    const CheckTextResponse& Resp)
	{
		TArray<FString> SensitiveWords;
		for (const auto& Word : Resp.dirty_words())
		{
			SensitiveWords.Add(STD_STRING_TO_FSTRING(Word));
		}

		CallBack(ErrorCode, ErrorMsg, Resp.passed(), SensitiveWords);
	};
	FCsdkCommonHttp<CheckTextResponse>::Request(
		TEXT("/spi/v3beta/sentiment/check/text"), Request, HttpCallBack);
}

void FConsensusManager::Accuse(const FCsdkAccuseToSentimentParam& ReportParam, const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg)>& CallBack) const
{
	AccuseToHeroSentimentRequest Request;
	Request.set_allocated_base(FCsdkCommonTools::MakePbBase());
	Request.mutable_item()->set_server_id(ReportParam.ServerId);
	Request.mutable_item()->set_role_id(FSTRING_TO_STD_STRING(ReportParam.RoleId));
	Request.mutable_item()->set_role_name(FSTRING_TO_STD_STRING(ReportParam.RoleName));
	Request.mutable_item()->set_level(ReportParam.Level);
	Request.mutable_item()->set_platform(ReportParam.Platform);
	Request.mutable_item()->set_vip_level(ReportParam.VipLevel);
	Request.mutable_item()->set_text(FSTRING_TO_STD_STRING(ReportParam.Text));
	Request.mutable_item()->set_remark(FSTRING_TO_STD_STRING(ReportParam.Remark));
	Request.mutable_item()->set_reason(FSTRING_TO_STD_STRING(ReportParam.Reason));

	auto HttpCallBack = [this,CallBack](const int32 ErrorCode, const FString& ErrorMsg,
										const CheckTextResponse& Resp)
	{
		CallBack(ErrorCode, ErrorMsg);
	};
	FCsdkCommonHttp<CheckTextResponse>::Request(
		TEXT("/spi/v3beta/sentiment/accuse/hero"), Request, HttpCallBack);
}
