﻿#include "CsdkCommand.h"

#include "Common/CsdkStringConvert.h"
#include "Log/CsdkLogMacros.h"
#include "Log/LogChatSdk.h"
#include "Manager/CsdkManager.h"
#include "Manager/CsdkSubsystem.h"
#include "message/model/operation.pb.h"
#include "Tools/CsdkCommonTools.h"
#include "Tools/Parser/ApiResult.h"

using heroim::client::v3beta::dto::message::model::Command;

void FCsdkCommand::SysCommand(const TArray<uint8>& Data)
{
	if(!FCsdkCommonTools::IsAlive())
		return;

	const Command PbCommand =TApiResult<Command>::ParseT(Data);
	FString JsonStr =STD_STRING_TO_FSTRING(PbCommand.data());
	if( PbCommand.command() == "HTC:KickOff" )
	{
		FCsdkManager::GetInstance().Subsystem->OnKickOff.Broadcast();
		FCsdkCommonTools::GetLoginManager().Logout();
		CSDK_LOG(LogChatSdk,Log,TEXT("Be kick off"));
	}
}
