
#include "SystemSetting.h"
#include "Tools/CsdkCommonTools.h"


void FSystemSetting::SetInitData(const FString& InProductId,const FString& InProductKey,const FString& Url)
{
	ProductId = InProductId;
	ProductKey = InProductKey;
	HttpAddress = Url;
}

void FSystemSetting::SetWsAddress(const FString& InAddress)
{
	WsAddress = InAddress;
}

void FSystemSetting::ClearInitData()
{
	ProductId.Empty();
	ProductKey.Empty();
	HttpAddress.Empty();
	WsAddress.Empty();
}

FString FSystemSetting::ToString() const
{
	FString FStringBuilder = FString::Printf(TEXT("{ProductId:%s,ProductKey:%s,Platform:%s,HttpAddress:%s}"),
	                                         *ProductId,
	                                         *ProductKey,
	                                         *StaticEnum<ECsdkPlatform>()->GetNameStringByValue(static_cast<int64>(FCsdkCommonTools::GetPlatform())),
	                                         *HttpAddress
	);
	return FStringBuilder;
}


