// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Log/Interface/ICsdkTrace.h"

/**
 * 
 */
class CSDKRUNTIME_API CsdkTrace : public ICsdkTrace
{
public:
 virtual void AddOutput(const TSharedPtr<ICsdkTraceOutput>& Output) override;
 virtual void SetTraceLevel(ELogVerbosity::Type Level) override;
 virtual void Log(const FName& Category, ELogVerbosity::Type Verbosity, const FString& Data) override;

private:
  TArray<TSharedPtr<ICsdkTraceOutput>> OutputArray;
  ELogVerbosity::Type LogLevel = ELogVerbosity::All;
};
