#pragma once
#include "../Data/CsdkLoginStatus.h"
#include "State/StateBase.h"
#include "User/Data/CsdkUser.h"

DECLARE_DELEGATE_TwoParams(FLoginCallback,const int32 ErrorCode,const FString&);

class FLoginManager
{
	friend class FCsdkCommonTools;
	friend class FStateBase;
	friend class FLoginStateBase;
	friend class FRoleIdLoginState;
	friend class FAuthCodeLoginState;
	friend class FLinkState;
	friend class FAuthState;
	friend class FOnlineState;
	friend class FOfflineState;
public:

	void Reset();

	void Login(const FCsdkUser& User, const FLoginCallback& InCallBack);
	void Login( const FString& InAuthCode, const FLoginCallback& InCallBack);
	
	void Logout();
	FORCEINLINE bool HasLogin() const
	{
		return bHasLogin;
	}
private:
	void PrepareLogin();
	void SwitchState(const ELoginStateId NewStateId);
	void OnRawMsgRecvEvent(const TArray<uint8>& RecvData) const;
	void OnWebSocketClosed(int64 StatusCode, const FString& Reason, bool bWasClean);
	void OnConnect();
	void OnConnectionError(const FString& Error) const;
private:
	TSharedPtr<class FWebSocketConnection> WebSocketConnection = nullptr;
	TMap<ELoginStateId,TSharedPtr<FStateBase>> StateMap;
	ELoginStateId CurrentState = ELoginStateId::PreLogin;
	bool bHasLogin = false;
	FString Token;
	FLoginCallback LoginCallback;
};

