#pragma once
#include "StateBase.h"
#include "Interfaces/IHttpRequest.h"


class FAuthState : public FStateBase
{
public:
	FAuthState(FLoginManager& InManager,const TSharedPtr<class FWebSocketConnection>& InWebSocketConnection)
	:FStateBase(InManager),
	WebSocketConnection(InWebSocketConnection){}

	virtual void Enter() override;
	virtual void OnWebSocketNotify(const TArray<uint8>& Data) override;
private:
	const TSharedPtr<class FWebSocketConnection> WebSocketConnection = nullptr;
};
