#pragma once
#include "StateBase.h"

class FReconnectTask : public FNonAbandonableTask
{
	friend class FAsyncTask<FReconnectTask>;

	FReconnectTask(const TSharedPtr<class FWebSocketConnection>& InWebSocketConnection)
		:WebSocketConnection(InWebSocketConnection)
	{}

	void DoWork() const;
	

	FORCEINLINE TStatId GetStatId() const
	{
		RETURN_QUICK_DECLARE_CYCLE_STAT(FReconnectTask, STATGROUP_ThreadPoolAsyncTasks);
	}

private:
	const TSharedPtr<class FWebSocketConnection> WebSocketConnection = nullptr;
};

class FOfflineState : public FStateBase
{
public:
	FOfflineState(FLoginManager& InManager,const TSharedPtr<class FWebSocketConnection>& InWebSocketConnection)
	:FStateBase(InManager),
	WebSocketConnection(InWebSocketConnection){}
	virtual  ~FOfflineState() override;

	virtual void Enter() override;
	virtual void Leave() override;
	
	void Release();
private:
	const TSharedPtr<class FWebSocketConnection> WebSocketConnection = nullptr;
	FAsyncTask<FReconnectTask>* MyTask = nullptr;
};
