#pragma once
#include "StateBase.h"


class FOnlineState : public FStateBase
{
public:
	FOnlineState(FLoginManager& InManager,const TSharedPtr<class FWebSocketConnection>& InWebSocketConnection)
	:FStateBase(InManager),
	WebSocketConnection(InWebSocketConnection){}
	virtual  ~FOnlineState() override;
	virtual void Enter() override;
	virtual void Leave() override;
	virtual void OnWebSocketNotify(const TArray<uint8>& Data) override;

	void Reset();
private:
	void StartHeartBeat();
	void StopHeartBeat();
	void ResetHeartBeat();
	void OnHeartBeat() const;
	void HeartBeat(float InDeltaTime);
	void FixTimeHeartBeat(float InDeltaTime);
	bool HandleTick(const float InDeltaTime);

private:
	const TSharedPtr<class FWebSocketConnection> WebSocketConnection = nullptr;
	int32 HeartBeatCount =0 ;
	CSDK_TickerHandle TickerHandle;
	float Duration = 0;
	float KeepAliveDuration = 0;
};


