﻿#pragma once
#include "../../Data/CsdkLoginStatus.h"

class FLoginManager;

class FStateBase:public TSharedFromThis<FStateBase>
{
public:
	FStateBase(FLoginManager& InManager)
	:Manager(InManager){}

	virtual ~FStateBase(){}
	virtual void Enter() = 0;
	virtual void Leave() {};
	virtual void OnWebSocketNotify(const TArray<uint8>& Data){}
protected:
	void SwitchState(const ELoginStateId NextState) const;
	void CallLoginCallback(const int32 ErrorCode, const FString& Msg) const;
protected:
	FLoginManager& Manager;
};

