﻿#include "UserLoginState.h"
#include "Common/CsdkStringConvert.h"
#include "../LoginManager.h"
#include "auth/auth_dto.pb.h"
#include "Tools/CsdkCommonTools.h"
#include "Log/CsdkLogMacros.h"
#include "socket/socket_dto.pb.h"
#include "Tools/CsdkCommonHttp.h"
#include "User/Tool/UserTool.h"

using namespace heroim::client::v3beta::dto::auth;

void FUserLoginState::Enter()
{
	RoleLoginRequest LoginRequest;
	LoginRequest.set_allocated_base(FCsdkCommonTools::MakePbBase());

	LoginRequest.set_allocated_userkey(CsdkUserTool::MakePbUserKey(User.Id));
	LoginRequest.set_rolename(FSTRING_TO_STD_STRING(User.RoleName));
	LoginRequest.set_gender(static_cast<heroim::client::v3beta::dto::user::model::Gender>(User.Gender));
	LoginRequest.set_avatarurl(FSTRING_TO_STD_STRING(User.AvatarUrl));
	for(const auto& ExtraItem : User.Extra)
	{
		LoginRequest.mutable_extra()->insert({FSTRING_TO_STD_STRING(ExtraItem.Key),FSTRING_TO_STD_STRING(ExtraItem.Value)});
	}

	CSDK_LOG(LogChatSdk,Log,TEXT("Enter User LoginState with LoginInfo:%s"),*User.ToString());
	
	auto selfWeak = this->AsWeak();
	auto CallBack =[selfWeak](const int32 ErrorCode,const FString& ErrorMsg,const LoginResponse& Resp)
	{
		if(selfWeak.IsValid())
		{
			const auto This = StaticCastSharedRef<FLoginStateBase>(selfWeak.Pin().ToSharedRef());
			This->HttpCallback(ErrorCode,ErrorMsg,Resp);
		}
		
	};
	FCsdkCommonHttp<LoginResponse>::Request(TEXT("/spi/v3beta/auth/login/role"),LoginRequest,CallBack);
}

