// Fill out your copyright notice in the Description page of Project Settings.

#include "Login/CsdkAuthCodeLogin.h"
#include "Tools/CsdkCommonTools.h"

UCsdkAuthCodeLogin* UCsdkAuthCodeLogin::CsdkAuthCodeLogin(UObject* WorldContextObject, const FString& AuthCode)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::IsInit(),TEXT("CSDK may not Init"))
#endif
	UCsdkAuthCodeLogin* Action = NewObject<UCsdkAuthCodeLogin>();
	Action->AuthCode = AuthCode;
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkAuthCodeLogin::Activate()
{
#if UE_SERVER	
	return;
#endif
	const auto Delegate = FLoginCallback::CreateLambda([this](const int32 ErrorCode, const FString ErrorMsg)
	{
		if(!IsValidLowLevel()) return;
			
		Completed.Broadcast(ErrorCode,ErrorMsg);
		SetReadyToDestroy();
	});
	FCsdkCommonTools::GetLoginManager().Login( AuthCode,Delegate);
}


