// Fill out your copyright notice in the Description page of Project Settings.

#include "Login/CsdkUserLogin.h"
#include "Tools/CsdkCommonTools.h"

UCsdkUserLogin* UCsdkUserLogin::CsdkUserLogin(UObject* WorldContextObject,const FCsdkUser& User)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::IsInit(),TEXT("CSDK may not Init"))
#endif
	
	UCsdkUserLogin* Action = NewObject<UCsdkUserLogin>();
	Action->User = User;
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkUserLogin::Activate()
{
#if UE_SERVER	
	return ;
#endif
	const auto Delegate = FLoginCallback::CreateLambda([this](const int32 ErrorCode, const FString ErrorMsg)
	{
		if(!IsValidLowLevel()) return;
		
		Completed.Broadcast(ErrorCode,ErrorMsg);
		SetReadyToDestroy();
	});
	FCsdkCommonTools::GetLoginManager().Login(User,Delegate);
}

