﻿#include "Message/Core/CsdkEventMessage.h"

#include "ChatRoom/Tool/ChatRoomTool.h"
#include "User/Tool/UserTool.h"

bool UCsdkEventMessage::GetFriendAddedInfo(FCsdkUser& FromUser, FCsdkUser& DistUser)
{
#if UE_SERVER	
	return {};
#endif
	const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<TCHAR>::Create(Data);
	// 创建一个Json对象
	TSharedPtr<FJsonObject> RootObject;
	// 反序列化，将JsonReader里面的数据，传到JsonObject中
	if(!FJsonSerializer::Deserialize(JsonReader, RootObject))
	{
		return false;
	}
	const TSharedPtr<FJsonObject>* FromUserObject =nullptr;
	RootObject->TryGetObjectField(TEXT("fromUser"),FromUserObject);
	const TSharedPtr<FJsonObject>* DistUserObject =nullptr;
	RootObject->TryGetObjectField(TEXT("distUser"),DistUserObject);
	FromUser = CsdkUserTool::ConvertUser(*FromUserObject);
	DistUser = CsdkUserTool::ConvertUser(*DistUserObject);
	
	return true;
}

bool UCsdkEventMessage::GetChatRoomCreateInfo(FCsdkUser& Creator, FCsdkChatRoomInfo& RoomInfo)
{
#if UE_SERVER	
	return {};
#endif
	const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<TCHAR>::Create(Data);
	// 创建一个Json对象
	TSharedPtr<FJsonObject> RootObject;
	// 反序列化，将JsonReader里面的数据，传到JsonObject中
	if(!FJsonSerializer::Deserialize(JsonReader, RootObject))
	{
		return false;
	}
	const TSharedPtr<FJsonObject>* CreatorObject =nullptr;
	RootObject->TryGetObjectField(TEXT("user"),CreatorObject);
	const TSharedPtr<FJsonObject>* RoomInfoObject =nullptr;
	RootObject->TryGetObjectField(TEXT("group"),RoomInfoObject);
	
	Creator = CsdkUserTool::ConvertUser(*CreatorObject);
	RoomInfo = CsdkChatRoomTool::ConvertRoomInfo(*RoomInfoObject);
	
	return true;
}

bool UCsdkEventMessage::GetChatRoomJoinedInfo(FCsdkUser& User, FCsdkChatRoomInfo& RoomInfo)
{
#if UE_SERVER	
	return {};
#endif
	const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<TCHAR>::Create(Data);
	// 创建一个Json对象
	TSharedPtr<FJsonObject> RootObject;
	// 反序列化，将JsonReader里面的数据，传到JsonObject中
	if(!FJsonSerializer::Deserialize(JsonReader, RootObject))
	{
		return false;
	}
	const TSharedPtr<FJsonObject>* UserObject =nullptr;
	RootObject->TryGetObjectField(TEXT("user"),UserObject);
	const TSharedPtr<FJsonObject>* RoomInfoObject =nullptr;
	RootObject->TryGetObjectField(TEXT("group"),RoomInfoObject);
	User = CsdkUserTool::ConvertUser(*UserObject);
	RoomInfo = CsdkChatRoomTool::ConvertRoomInfo(*RoomInfoObject);
	
	return true;
}

bool UCsdkEventMessage::GetChatRoomQuitedInfo(FCsdkUser& User, FCsdkChatRoomInfo& RoomInfo)
{
#if UE_SERVER	
	return {};
#endif
	const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<TCHAR>::Create(Data);
	// 创建一个Json对象
	TSharedPtr<FJsonObject> RootObject;
	// 反序列化，将JsonReader里面的数据，传到JsonObject中
	if(!FJsonSerializer::Deserialize(JsonReader, RootObject))
	{
		return false;
	}
	const TSharedPtr<FJsonObject>* UserObject =nullptr;
	RootObject->TryGetObjectField(TEXT("user"),UserObject);
	const TSharedPtr<FJsonObject>* RoomInfoObject =nullptr;
	RootObject->TryGetObjectField(TEXT("group"),RoomInfoObject);
	User = CsdkUserTool::ConvertUser(*UserObject);
	RoomInfo = CsdkChatRoomTool::ConvertRoomInfo(*RoomInfoObject);
	
	return true;
}

bool UCsdkEventMessage::GetChatRoomMemberRemovedInfo(FCsdkUser& Operator, FCsdkUser& DistUser,
	FCsdkChatRoomInfo& RoomInfo)
{
#if UE_SERVER	
	return {};
#endif
	const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<TCHAR>::Create(Data);
	// 创建一个Json对象
	TSharedPtr<FJsonObject> RootObject;
	// 反序列化，将JsonReader里面的数据，传到JsonObject中
	if(!FJsonSerializer::Deserialize(JsonReader, RootObject))
	{
		return false;
	}
	const TSharedPtr<FJsonObject>* OperatorObject =nullptr;
	RootObject->TryGetObjectField(TEXT("user"),OperatorObject);
	const TSharedPtr<FJsonObject>* DistUserObject =nullptr;
	RootObject->TryGetObjectField(TEXT("distUser"),DistUserObject);
	const TSharedPtr<FJsonObject>* RoomInfoObject =nullptr;
	RootObject->TryGetObjectField(TEXT("group"),RoomInfoObject);

	Operator = CsdkUserTool::ConvertUser(*OperatorObject);
	DistUser = CsdkUserTool::ConvertUser(*DistUserObject);
	RoomInfo = CsdkChatRoomTool::ConvertRoomInfo(*RoomInfoObject);
	
	return true;
}

bool UCsdkEventMessage::GetChatRoomDismissedInfo(FCsdkUser& Operator, FCsdkChatRoomInfo& RoomInfo)
{
#if UE_SERVER	
	return {};
#endif
	const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<TCHAR>::Create(Data);
	// 创建一个Json对象
	TSharedPtr<FJsonObject> RootObject;
	// 反序列化，将JsonReader里面的数据，传到JsonObject中
	if(!FJsonSerializer::Deserialize(JsonReader, RootObject))
	{
		return false;
	}
	const TSharedPtr<FJsonObject>* OperatorObject =nullptr;
	RootObject->TryGetObjectField(TEXT("user"),OperatorObject);
	const TSharedPtr<FJsonObject>* RoomInfoObject =nullptr;
	RootObject->TryGetObjectField(TEXT("group"),RoomInfoObject);
	
	Operator = CsdkUserTool::ConvertUser(*OperatorObject);
	RoomInfo = CsdkChatRoomTool::ConvertRoomInfo(*RoomInfoObject);
	return true;
}

void UCsdkEventMessage::SetData(const FString& InData)
{
#if UE_SERVER	
	return;
#endif
	Data =InData;
}


