﻿#include "Message/Core/CsdkTextMessage.h"
#include "Tools/CsdkCommonTools.h"

void UCsdkTextMessage::Translate(const FString& SourceLang, const FString& TargetLang,
                                 const FTranslateCallback& Callback)
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetTranslateManager().Translate(Content, SourceLang, TargetLang,
	[this, Callback](const int32 ErrorCode, const FString& ErrorMsg, const FString& Translated, const FString& SourceLang)
		{
			if(this->IsValidLowLevel())
			{
				this->TranslatedContent = Translated;
				this->SourceLanguage = SourceLang;
			}
			Callback.ExecuteIfBound(ErrorCode, ErrorMsg);
		});
}
