﻿#pragma once

#include "CsdkMessageRingBuffer.h"
#include "Message/Core/CsdkMessageBase.h"
#include "Message/Data/CsdkMsgPullDirection.h"
#include "Message/Data/MessageEventType.h"
#include "Session/Data/CsdkSessionId.h"

class FMessageManager
{
public:
	void Reset();
	static void SendMsg(const FCsdkSessionId& SessionId,UCsdkMessageBase* CsdkMessage,
		const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg)>& Callback);
	
	void PullMessage(const FCsdkSessionId& SessionId, const FString& AnchorMsgId, const int32 DesiredPullCount, const ECsdkMsgPullDirection Direction,
					 const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<UCsdkMessageBase*>& Msgs)>& Callback);

	void MsgNotify(const TArray<uint8>& Data);

	void OnEventReceived(const EMessageEventType EventType, const FString& JsonData);
private:
	TSharedPtr<FCsdkMessageRingBuffer> GetRingBuffer(const FCsdkSessionId& SessionId);
	TMap<FCsdkSessionId,TSharedPtr<FCsdkMessageRingBuffer> > SessionId2RingBuffer;
};


