#include "Message/CsdkSendMsg.h"
#include "Tools/CsdkCommonTools.h"


UCsdkSendMsg* UCsdkSendMsg::SendMsg(UObject* WorldContextObject, const FCsdkSessionId& SessionId,
	UCsdkMessageBase* CsdkMessage)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif

	UCsdkSendMsg* Action = NewObject<UCsdkSendMsg>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->SessionId = SessionId;
	Action->CsdkMessage = CsdkMessage;
	return Action;
}

void UCsdkSendMsg::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetMessageManager().SendMsg(SessionId,CsdkMessage,
	[this](const int32 ErrorCode, const FString& ErrorMsg)
	{
		if(!IsValidLowLevel())
			return;

		this->Completed.Broadcast(ErrorCode,ErrorMsg);
		this->SetReadyToDestroy();
	});
}
