﻿
#include "Platform/Android/AndroidGateway.h"
#if PLATFORM_ANDROID
#include "Android/AndroidPlatform.h"
#include "Android/AndroidJava.h"
#include "Android/AndroidApplication.h"
#include <android_native_app_glue.h>
#include "AndroidPermissionCallbackProxy.h"
#include "AndroidPermissionFunctionLibrary.h"
#endif



bool FAndroidGateway::IsPermissionRecordAudioGranted()
{
#if PLATFORM_ANDROID
	return UAndroidPermissionFunctionLibrary::CheckPermission(m_RecordPermission);
#endif
}

void FAndroidGateway::AskPermissionRecordAudio()
{
#if PLATFORM_ANDROID
	TArray<FString> permissions;
	permissions.Add(m_RecordPermission);
	UAndroidPermissionFunctionLibrary::AcquirePermissions(permissions);
#endif
}