// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Block/CsdkAddBlock.h"
#include "Tools/CsdkCommonTools.h"

UCsdkAddBlock* UCsdkAddBlock::AddBlock(UObject* WorldContextObject, const FCsdkUserId& UserId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkAddBlock* Action = NewObject<UCsdkAddBlock>();
	Action->UserId = UserId;
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkAddBlock::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetBlockManager().AddBlock(UserId,
		[this](const int32 ErrorCode,const FString& Msg)
		{
			if(!this->IsValidLowLevel())
				return;
			
			Completed.Broadcast(ErrorCode,Msg);
			this->SetReadyToDestroy();
		});
}


