// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Block/CsdkRemoveBlock.h"
#include "Tools/CsdkCommonTools.h"

UCsdkRemoveBlock* UCsdkRemoveBlock::RemoveBlock(UObject* WorldContextObject, const FCsdkUserId& UserId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkRemoveBlock* Action = NewObject<UCsdkRemoveBlock>();
	Action->UserId = UserId;
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkRemoveBlock::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetBlockManager().RemoveBlock(UserId,
		[this](const int32 ErrorCode, const FString& Msg)
		{
			if(!this->IsValidLowLevel())
				return;
			
			Completed.Broadcast(ErrorCode,Msg);
			this->SetReadyToDestroy();
		});
}


