// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Friend/CsdkFriendApplyOperate.h"

#include "Common/CsdkErrorCode.h"
#include "Log/CsdkLogMacros.h"
#include "Log/LogChatSdk.h"
#include "Tools/CsdkCommonTools.h"


UCsdkFriendApplyOperate* UCsdkFriendApplyOperate::AgreeFriendApply(UObject* WorldContextObject, const FString& Token)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkFriendApplyOperate* Action = NewObject<UCsdkFriendApplyOperate>();
	Action->RegisterWithGameInstance(WorldContextObject);

	FCsdkCommonTools::GetFriendManager().AgreeFriendApply({Token},
   [Action,Token](const int32 ErrorCode,const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& AgreeListResult )
   {
		if(!Action->IsValidLowLevel())
			return;
   		if(ErrorCode!=ECsdkErrorCode::Success)
   		{
   			Action->Completed.Broadcast(ErrorCode,ErrorMsg);
   		}
   		else if (AgreeListResult.Num()>0 &&Token ==AgreeListResult[0].Token)
   		{
   			Action->Completed.Broadcast(AgreeListResult[0].ErrorCode,AgreeListResult[0].Msg);
   		}
        else
        {
        	Action->Completed.Broadcast(ECsdkErrorCode::Failed,TEXT("Agree Apply List Result is empty"));
        	CSDK_LOG(LogChatSdk,Error,TEXT("Agree Apply List Result is empty"));
        }
		Action->SetReadyToDestroy();
});
	return Action;
}

UCsdkFriendApplyOperate* UCsdkFriendApplyOperate::RefuseFriendApply(UObject* WorldContextObject,
	const FString& Token)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkFriendApplyOperate* Action = NewObject<UCsdkFriendApplyOperate>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	FCsdkCommonTools::GetFriendManager().RefuseFriendApply({Token},
   [Action,Token](const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& AgreeListResult )
   {
   	if(!Action->IsValidLowLevel())
   		return;
		  if(ErrorCode!=ECsdkErrorCode::Success)
		  {
			  Action->Completed.Broadcast(ErrorCode,ErrorMsg);
		  }
		  else if (AgreeListResult.Num()>0 &&Token ==AgreeListResult[0].Token)
		  {
			  Action->Completed.Broadcast(AgreeListResult[0].ErrorCode,AgreeListResult[0].Msg);
		  }
	   else
	   {
		   Action->Completed.Broadcast(ECsdkErrorCode::Failed,TEXT("Refuse Apply List Result is empty"));
		   CSDK_LOG(LogChatSdk,Error,TEXT("Refuse Apply List Result is empty"));
	   }
	   Action->SetReadyToDestroy();
   	
   });
	return Action;
}
