// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Friend/CsdkGetFriendApplyList.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetFriendApplyList* UCsdkGetFriendApplyList::GetFriendApplyList(UObject* WorldContextObject)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetFriendApplyList* Action = NewObject<UCsdkGetFriendApplyList>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().GetFriendApplyList(
   [Action](const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkFriendApply>& ApplyList)
   {
   		if(!Action->IsValidLowLevel())
   			return;
   	
   		Action->Completed.Broadcast(ErrorCode, ErrorMsg, ApplyList);
   		Action->SetReadyToDestroy();
   });
	return Action;
}


