// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Friend/CsdkOperateFriendList.h"

#include "Relationship/Friend/Data/CsdkFriendDelResult.h"
#include "Tools/CsdkCommonTools.h"


UCsdkOperateFriendList* UCsdkOperateFriendList::DeleteFriendMulti(UObject* WorldContextObject,const TArray<FCsdkUserId>& UserIds)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkOperateFriendList* Action = NewObject<UCsdkOperateFriendList>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().DeleteFriendMulti(UserIds,
		[Action](const int32 ErrorCode,const FString& ErrorMsg, const TArray<FCsdkFriendDelResult>& Result)
		{
			if(!Action->IsValidLowLevel())
				return;
			
			Action->Completed.Broadcast(ErrorCode,ErrorMsg, Result);
			Action->SetReadyToDestroy();
		});
	return Action;
}