#pragma once
#include "ChatRoom/Data/ChatRoomEventType.h"
#include "Relationship/Friend/Data/CsdkFriend.h"
#include "Relationship/Friend/Data/CsdkFriendApply.h"
#include "Relationship/Friend/Data/CsdkOperateFriendApplyResult.h"
#include "Relationship/Friend/Data/CsdkFriendApplyResult.h"
#include "Relationship/Friend/Data/CsdkFriendDelResult.h"
#include "Relationship/Friend/Data/RelationshipEventType.h"
#include "Relationship/Friend/FriendApply/FriendApplyManager.h"


class FFriendManager 
{
public:
	void Init();
	void Reset();
	static void GetFriendList(const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkFriend>& FriendList)>& Callback);
	void GetFriendApplyList(
		const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkFriendApply>& ApplyList)>& Callback);
	static void AddFriend(const FCsdkUserId& UserId,const TFunction<void(const int32 ErrorCode, const FString&)>& Callback);
	static void DeleteFriend(const FCsdkUserId& UserId,const TFunction<void(const int32 ErrorCode, const FString&)>& Callback);
	static void DeleteFriendMulti(const TArray<FCsdkUserId>& UserIds,const TFunction<void(const int32 ErrorCode, const FString&, const TArray<FCsdkFriendDelResult>& DelResult)>& Callback);
	static void UpdateFriendInfo(const FCsdkUserId& UserId, const TMap<FString, FString>& UserInfoExtra, const TFunction<void(const int32 ErrorCode, const FString&)>& Callback);
	
	void AgreeFriendApply(const TArray<FString>& ApplyTokens,
		const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& AgreeListResult )>& Callback);
	void RefuseFriendApply(const TArray<FString>& ApplyTokens,
	const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& RefuseListResult )>& Callback);

	void OnEventReceived(const ERelationshipEventType EventType, const FString& JsonData);
	int32 GetUnreadCount();
	void ClearUnreadCount();
private:
	
	void OnFriendApplied(const FString& JsonData);
	void OnFriendAdded(const FString& JsonData);
	static void OnFriendDeleted(const FString& JsonData);

	FFriendApplyManager FriendApplyCache;
};




