﻿#pragma once

#include "Session/Data/CsdkSession.h"


class FSessionList :public FGCObject
{
public:
	virtual void AddReferencedObjects( FReferenceCollector& Collector ) override;
	virtual FString GetReferencerName() const override
	{
		return TEXT("FSessionList");
	}
	void Initialize(TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,TArray<UCsdkSession*>)> Callback);
	void Empty();
	bool IsEmpty() const;
	void Add(UCsdkSession* NewSession);
	bool Contains(const FCsdkSessionId& Id) const;
	TObjectPtr<UCsdkSession> Find(const FCsdkSessionId& Id) const;
	TObjectPtr<UCsdkSession> RemoveLocalSession(const FCsdkSessionId& Id);

	void Sort();
	
	void GetSessionList( TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,TArray<UCsdkSession*>)> Callback);
	void DeleteSession( const FCsdkSessionId& SessionId, const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg)>& Callback );

	void PinSession( const FCsdkSessionId& SessionId,const	bool bIsPinned, const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const FDateTime& PinnedTime)>& Callback);
	
	
	using SessionIterator = TArray<TObjectPtr<UCsdkSession>>::RangedForIteratorType;
	using SessionConstIterator = TArray<TObjectPtr<UCsdkSession>>::RangedForConstIteratorType;
	
	SessionIterator begin();      
	SessionConstIterator begin() const;
	SessionIterator end  () ;     
	SessionConstIterator end  () const;

private:
	void GetRemoteSessionList(TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,TArray<UCsdkSession*>)> Callback =nullptr);
	void JoinChatRoomBySession();
	TArray<TObjectPtr<UCsdkSession>>  GetAsArray() const;
private:
	TArray<TObjectPtr<UCsdkSession>> SessionArray;
	TMap<FCsdkSessionId, TObjectPtr<UCsdkSession>> SessionMap;



};

