#include "Session/CsdkDeleteSession.h"

#include "ChatRoom/CsdkQuitChatRoom.h"
#include "Tools/CsdkCommonTools.h"


UCsdkDeleteSession* UCsdkDeleteSession::DeleteSession(UObject* WorldContextObject, const FCsdkSessionId& UniqueId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkDeleteSession* Action = NewObject<UCsdkDeleteSession>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->SessionId = UniqueId;
	return Action;
}

void UCsdkDeleteSession::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetSessionManager().DeleteSession(SessionId,
		[this](const int32 ErrorCode,const FString& ErrorMsg)
		{
			if(!IsValidLowLevel())
				return;
			
			this->Completed.Broadcast(ErrorCode,ErrorMsg);
			this->SetReadyToDestroy();
		});
}
