// Fill out your copyright notice in the Description page of Project Settings.


#include "Translate/CsdkTranslateAction.h"
#include "Tools/CsdkCommonTools.h"

UCsdkTranslateAction* UCsdkTranslateAction::Translate(UObject* WorldContextObject,const FString& Content,const FString& SourceLanguage,const FString& TargetLanguage)
{
#if UE_SERVER	
	return {};
#endif
	UCsdkTranslateAction* Action = NewObject<UCsdkTranslateAction>();
	Action->Content = Content;
	Action->SourceLanguage = SourceLanguage;
	Action->TargetLanguage = TargetLanguage;
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkTranslateAction::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetTranslateManager().Translate(Content, SourceLanguage, TargetLanguage,
   [this](const int32 ErrorCode, const FString& Msg, const FString& TranslatedContent, const FString& SourceLang)
   {
	   if (!this->IsValidLowLevel())
		   return;

	   Completed.Broadcast(
		   ErrorCode, Msg, TranslatedContent, SourceLang);
	   this->SetReadyToDestroy();
   });
}
