﻿#include "TranslateManager.h"
#include "message/message_dto.pb.h"
#include "Tools/CsdkCommonHttp.h"
#include "Tools/CsdkCommonTools.h"

using namespace heroim::client::v3beta::dto::message;

void FTranslateManager::Translate(const FString& Content, const FString& SourceLanguage, const FString& TargetLanguage,
                                  const TFunction<void(const int32 ErrorCode, const FString&, const FString&, const FString&)>& CallBack) const
{
	MessageTranslateRequest TranslateRequest;
	TranslateRequest.set_allocated_base(FCsdkCommonTools::MakePbBase());
	TranslateRequest.set_content(FSTRING_TO_STD_STRING(Content));
	TranslateRequest.set_sourcelanguage(FSTRING_TO_STD_STRING(SourceLanguage));
	TranslateRequest.set_targetlanguage(FSTRING_TO_STD_STRING(TargetLanguage));

	auto HttpCallBack = [this,CallBack](const int32 ErrorCode, const FString& ErrorMsg,
	                                    const MessageTranslateResponse& Resp)
	{
		const FString Content = STD_STRING_TO_FSTRING(Resp.content());
		const FString SourceLang = STD_STRING_TO_FSTRING(Resp.sourcelanguage());
	
		CallBack(ErrorCode, ErrorMsg, Content, SourceLang);
	};
	FCsdkCommonHttp<MessageTranslateResponse>::Request(
		TEXT("/spi/v3beta/message/translate"), TranslateRequest, HttpCallBack);
}
