#include "User/CsdkGetUserControl.h"
#include "Tools/CsdkCommonTools.h"

UCsdkGetUserControl* UCsdkGetUserControl::GetUserControl(UObject* WorldContextObject)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetUserControl* Action = NewObject<UCsdkGetUserControl>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	return Action;
}

void UCsdkGetUserControl::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetUserManager().GetUserControl([this](const int32 ErrorCode, const FString& ErrorMsg, const FCsdkUserControl& CsdkUserControl)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg, CsdkUserControl);
		this->SetReadyToDestroy();
	});
}
