#include "User/CsdkGetUserList.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetUserList* UCsdkGetUserList::GetUserList(UObject* WorldContextObject,
                                   const TArray<FCsdkUserId>& UserIdList)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetUserList* Action = NewObject<UCsdkGetUserList>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	Action->UserIdList = UserIdList;
	return Action;
}

void UCsdkGetUserList::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetUserManager().GetUserList(UserIdList,
	[this](const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkUser>& UserList)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg,UserList);
		this->SetReadyToDestroy();
	});
}
