﻿
#include "User/CsdkUpdateUser.h"
#include "Tools/CsdkCommonTools.h"


UCsdkUpdateUser* UCsdkUpdateUser::UpdateUser(UObject* WorldContextObject,
									const FString& RoleName,const ECsdkGender& Gender,const FString& AvatarUrl,const TMap<FString,FString>&  Extra)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkUpdateUser* Action = NewObject<UCsdkUpdateUser>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	Action->RoleName = RoleName;
	Action->Gender = Gender;
	Action->AvatarUrl = AvatarUrl;
	Action->Extra = Extra;
	return Action;
}

void UCsdkUpdateUser::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetUserManager().UpdateUser(RoleName, Gender, AvatarUrl, Extra,
	[this](const int32 ErrorCode,const FString& ErrorMsg)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg);
		this->SetReadyToDestroy();
	});
}
