#include "User/CsdkUserLibrary.h"

#include "Tools/CsdkCommonTools.h"


FCsdkUser UCsdkUserLibrary::GetCurrentUser()
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	return FCsdkCommonTools::GetUserManager().GetCurrentUser();
}

FString UCsdkUserLibrary::GetCsdkServerId()
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	return FCsdkCommonTools::GetSeverId();
}

FString UCsdkUserLibrary::Conv_UserIdToString(const FCsdkUserId& UserId)
{
#if UE_SERVER	
	return {};
#endif
	return UserId.ToString();
}

FString UCsdkUserLibrary::Conv_UserToString(const FCsdkUser& User)
{
#if UE_SERVER	
	return {};
#endif
	return User.ToString();
}
