#pragma once

#include "User/Data/CsdkUser.h"
#include "User/Data/CsdkUserControl.h"
#include "User/Data/CsdkUserId.h"
#include "User/Data/CsdkUserSearch.h"
#include "User/Data/CsdkUserStatus.h"
#include "User/Data/UserEventType.h"

class FUserManager
{
	friend class FCsdkCommonTools;
public:
	void Reset();
	void SetCurrentUser(const FCsdkUser& User)
	{
		CurrentUser = User;
	}

	FORCEINLINE FCsdkUserId GetCurrentUserId() const
	{
		return CurrentUser.Id;
	}

	FORCEINLINE FCsdkUser GetCurrentUser() const
	{
		return CurrentUser;
	}

	FString GetCurrentUserSavePath() const;

	static void GetUserList(const TArray<FCsdkUserId>& UserIdList,
	                        const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg, const TArray<FCsdkUser>& UserList)>& Callback);
	
	static void GetUserListStatus(const TArray<FCsdkUserId> & UserIds,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg, const TArray<FCsdkUserStatusResult> & StatusResultList)>& Callback);
	
	void UpdateUser(const FString& RoleName,const ECsdkGender& Gender,const FString& AvatarUrl,const TMap<FString,FString>&  Extra,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg)>& Callback);
	
	static void SearchUser(const TArray<FCsdkUserSearchCondition>& Conditions,const int32 PageNo,const int32 PageSize,
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg, const TArray<FCsdkUser> & UserList)>& Callback);

	static void OnEventReceived(const EUserEventType EventType, const FString& JsonData);
	static void GetUserControl(
		const TFunction<void(const int32 ErrorCode,const FString& ErrorMsg, const FCsdkUserControl& CsdkUserControl)>& Callback);
private:
	FCsdkUser CurrentUser;

	static void OnUserProfileChanged(const FString& JsonData);
	static void OnUserStatusChanged(const FString& JsonData);
	static void OnUserControlChanged(const FString& JsonData);
	static void OnUserConnected(const FString& JsonData);
	static void OnUserDisconnected(const FString& JsonData);
};
