#pragma once
#include "Common/CsdkStringConvert.h"
#include "message/model/message_model.pb.h"
#include "User/Data/CsdkUser.h"
#include "User/Data/CsdkUserControl.h"
#include "User/Data/CsdkUserId.h"
#include "User/Data/CsdkUserStatus.h"
#include "user/model/user_model.pb.h"

namespace CsdkUserTool
{

	FCsdkUser ConvertUser(const heroim::client::v3beta::dto::user::model::User& PbUserBase);

	FCsdkUser ConvertUser(const heroim::client::v3beta::dto::user::model::UserSimple& PbMessageUser);

	FCsdkUser ConvertUser(const TSharedPtr<FJsonObject>& UserObject);

	inline heroim::client::v3beta::dto::user::model::UserKey* MakePbUserKey(const FCsdkUserId& UserId)
	{
		heroim::client::v3beta::dto::user::model::UserKey* PbUserKey = new heroim::client::v3beta::dto::user::model::UserKey;
		PbUserKey->set_roleid(FSTRING_TO_STD_STRING(UserId.RoleId));
		PbUserKey->set_serverid(FSTRING_TO_STD_STRING(UserId.ServerId));
		return PbUserKey;
	}

	
	inline FCsdkUserId ConvertUserId(const heroim::client::v3beta::dto::user::model::UserKey& PbRoomId)
	{
		FCsdkUserId UniqueId;
		UniqueId.RoleId = STD_STRING_TO_FSTRING(PbRoomId.roleid());
		UniqueId.ServerId = STD_STRING_TO_FSTRING(PbRoomId.serverid());
		return UniqueId;
	}

	inline FCsdkUserId ConvertUserId(const TSharedPtr<FJsonObject>& UserKeyObject)
	{
		FCsdkUserId UniqueId;
		FString RoleId, ServerId;
		UserKeyObject->TryGetStringField(TEXT("roleId"), RoleId);
		UserKeyObject->TryGetStringField(TEXT("serverId"), ServerId);
		UniqueId.RoleId = RoleId;
		UniqueId.ServerId = ServerId;
		return UniqueId;
	}

	FCsdkUserStatus ConvertUserStatus(const TSharedPtr<FJsonObject>& UserStatusObj);

	void ConvertControlStatus(const TSharedPtr<FJsonObject>& ControlStatusObj, FCsdkUserControl& CsdkUserControl);
}
