// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkChatRoomId.h"
#include "Data/CsdkChatRoomInfo.h"
#include "Kismet/BlueprintFunctionLibrary.h"
#include "CsdkChatRoomLibrary.generated.h"

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkChatRoomLibrary : public UBlueprintFunctionLibrary 
{
	GENERATED_BODY()
public:
	UFUNCTION(BlueprintPure, Category = "CSDK|ChatRoom", meta = (DisplayName = "ToChatRoomId", CompactNodeTitle = "->", Keywords = "cast convert", BlueprintAutocast))
	static  FCsdkChatRoomId Conv_FStringToChatRoomId( const FString& CustomId);

	UFUNCTION(BlueprintPure, Category="CSDK|ChatRoom")
	static bool IsValid(const FCsdkChatRoomId& A);
	
	UFUNCTION(BlueprintPure, Category = "CSDK|ChatRoom", meta = (DisplayName = "ToString(ChatRoomId)", CompactNodeTitle = "->", BlueprintAutocast))
	static  FString Conv_ChatRoomIdToString(const FCsdkChatRoomId& RoomId);

	/**
	 * @brief 通过ID获取聊天室信息
	 * @param RoomId 聊天室ID
	 * @param ChatRoomInfo 聊天室信息
	 * @return 是否获取成功
	 */
	UFUNCTION(BlueprintPure, Category = "CSDK|ChatRoom")
	static  bool GetChatRoomInfoById(const FCsdkChatRoomId& RoomId, FCsdkChatRoomInfo& ChatRoomInfo);

	/**
	 * @brief 获取当前用户所有的聊天室信息
	 * @return 
	 */
	UFUNCTION(BlueprintPure, Category = "CSDK|ChatRoom")
	static  TArray<FCsdkChatRoomInfo> GetChatRoomsInfo();
};


