// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkChatRoomId.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkDissolveChatRoom.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkDissolveChatRoomResult,const int32,ErrorCode,const FString&, ErrorMsg);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkDissolveChatRoom : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 解散聊天室
	 * @param WorldContextObject 
	 * @param RoomId 聊天室ID
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|ChatRoom")
	static UCsdkDissolveChatRoom* DissolveChatRoom(UObject* WorldContextObject,const FCsdkChatRoomId& RoomId);
	
	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkDissolveChatRoomResult Completed;
	
private:
	FCsdkChatRoomId ChatRoomId;
};


