// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkChatRoomInfo.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkJoinChatRoom.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkJoinChatRoomResult,const int32,ErrorCode,const FString&, ErrorMsg,const FCsdkChatRoomInfo&, ChatRoomInfo);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkJoinChatRoom : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 加入一个已经存在的聊天室
	 * @param WorldContextObject 
	 * @param RoomId 聊天室ID
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|ChatRoom")
	static UCsdkJoinChatRoom* JoinChatRoom(UObject* WorldContextObject,const FCsdkChatRoomId& RoomId);

	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkJoinChatRoomResult Completed;

private:
	FCsdkChatRoomId ChatRoomId;
};


