﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "JsonObjectConverter.h"
#include "CsdkChatRoomId.generated.h"


USTRUCT(BlueprintType)
struct FCsdkChatRoomId
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|ChatRoom")
	FString CustomId;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|ChatRoom")
	FString ServerId;

	bool operator==(const FCsdkChatRoomId& Other) const
	{
		return this->CustomId==Other.CustomId && this->ServerId ==Other.ServerId;
	}

	FString ToString() const
	{
		return ServerId.IsEmpty() ? CustomId : CustomId + TEXT("_") + ServerId;
	}

	bool IsValid() const 
	{
		return !CustomId.IsEmpty() && !ServerId.IsEmpty();
	}
};

FORCEINLINE uint32 GetTypeHash(const FCsdkChatRoomId& S)
{
	const auto Str = S.CustomId+TEXT(":")+S.ServerId;
	return FCrc::Strihash_DEPRECATED(Str.Len(), *Str);
}
