﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "CsdkChatRoomId.h"
#include "JsonObjectConverter.h"
#include "CsdkChatRoomInfo.generated.h"


USTRUCT(BlueprintType)
struct FCsdkChatRoomCreateParam
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|ChatRoom")
	FString RoomType;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|ChatRoom")
	FString RoomName;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|ChatRoom")
	FString Icon;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|ChatRoom")
	TMap<FString,FString> Extra;

	FString ToString() const
	{
		FString Result;
		FJsonObjectConverter::UStructToJsonObjectString(*this,Result);
		return Result;
	}
};


USTRUCT(BlueprintType)
struct FCsdkChatRoomInfo
{
	GENERATED_BODY()

	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|ChatRoom")
	FCsdkChatRoomId RoomId;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|ChatRoom")
	FString RoomType;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|ChatRoom")
	FString RoomName;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|ChatRoom")
	FString Icon;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|ChatRoom")
	TMap<FString,FString> Extra;

	FString ToString() const
	{
		FString Result;
		FJsonObjectConverter::UStructToJsonObjectString(*this,Result);
		return Result;
	}
};

