// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

namespace ECsdkErrorCode
{
	enum Type
	{
		ClientError =-1,
		//服务器端枚举
		UnReachable =0,//Http请求不可达 
		Success =2000, // 成功
		Failed = 2001,// 失败
		ParamInvalid = 2002,// 参数错误
		SignInvalid = 2003,// 签名验证错误
		SystemError = 2004, // 系统错误
		RequestExpired = 2005,// 请求已过期
		ResourceNotFound = 2006,// 资源不存在
		NoneAccess = 2007,	// 未授权访问
		AuthExpired = 2008, // 授权已失效，请重新访问
		StreamLimited = 2009,// 被限流
		PermissionDenied = 2010,// 权限不足
		RecordDuplicated = 2011, // 已存在相同的记录

		NotFriend = 3001, // 不是好友
		BeBlocked = 3002, // 被拉黑
		AlreadyFriend = 3003, // 已经是好友
		MaxLimited = 3004, // 数量已达到上限
		RepeatApply = 3005, // 重复发起申请
		BlockedDist = 3006, // 已经将对方拉黑
		TargetMaxLimited =3007,// 好友数量已达到上限(对方) 
		ApplyBlocked =3008,//对方已经被你拉黑
		FriendApplyMaxLimited =3009, // 好友申请数量已达到上限(对方)

		GroupNotJoined = 4001,// 未加入群
		GroupBlocked = 4002, // 被群拉黑
		GroupJoinForbid = 4003, // 禁止加入
		GroupAlreadyInOther = 4004, // 已经加入其它群组,不可Join
		GroupMaxLimited = 4005, // 人数达到上限
		GroupAlreadyExists = 4006, // 已存在相同的群组
		
		MsgRateLimit = 5001, // 消息发送频率超过限制
		MsgSilenced = 5002, // 已经被禁言
		MsgEvil = 5003 ,// 消息内容不合法

		SessionPinLimit = 6001  // 会话置顶触发上限
	}; 
}
