﻿#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Data/ReportToHeroParams.h"
#include "CsdkSensitiveTextCheck.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_FourParams(FCsdkSensitiveTextCheckResult, const int32, ErrorCode, const FString&, ErrorMsg, const bool, bPassed, const TArray<FString>&, SensitiveWords);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkSensitiveTextCheck : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 
	 * @param WorldContextObject 
	 * @param Text 待检查的文本
	 * @param ReportParam 配置参数
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Consensus")
	static UCsdkSensitiveTextCheck* SensitiveTextCheck(UObject* WorldContextObject, const FString& Text, const FCsdkSensitiveTextCheckParam& ReportParam);

	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkSensitiveTextCheckResult Completed;

private:
	FString SourceText;
	FCsdkSensitiveTextCheckParam ReportToHeroParam;
};


